<?php
/******************************* 
  * Function by ellajardim.com.br *
  ------------------------------
********************************/
function rc_my_welcome_panel() { ?>

	<script type="text/javascript">
		// Hide default welcome message
		jQuery(document).ready( function($) {
			$('div.welcome-panel-content').hide();
		});
	</script>

	<div class="custom-welcome-panel-content">
		<h3><?php _e( 'Oie, bem vinda de volta ao painel do '.get_bloginfo('name').' &hearts; ' ); ?></h3>
		<p class="about-description"><?php _e( 'Fico muito grata por fazer parte da sua história online. Seu painel está de cara nova, mas está tudo no mesmo lugar, ok? <br>Abaixo estão algumas coisas que você pode fazer para começar a usar seu blog novamente.<br> Caso precise, entre em contato comigo através do botão rosa abaixou, ou preenchendo o <a href="https://ellajardim.com.br/contato">formulário de contato</a> ou usando umas das redes sociais:<br><br><a href="https://www.instagram.com/ellajardim/" target="blank">Instagram</a> | <a href="https://www.pinterest.de/ellajardim" target="blank">Pinterest</a> | <a href="https://www.facebook.com/ellajardim/" target="blank">Facebook</a> ' ); ?></p>
		<div class="welcome-panel-column-container">
			<div class="welcome-panel-column">
				<h4><?php _e( "Para começar..." ); ?></h4>
				<a class="button button-primary button-hero load-customize hide-if-no-customize" href="http://ellajardim.com.br"><?php _e( 'Entre em contato' ); ?></a>
					<p class="hide-if-no-customize"><?php printf( __( 'ou, <a href="%s">edite as infos do seu blog</a>' ), admin_url( 'options-general.php' ) ); ?></p>
			</div><!-- .welcome-panel-column -->
			<div class="welcome-panel-column">
				<h4><?php _e( 'Next Steps' ); ?></h4>
				<ul>
				<?php if ( 'page' == get_option( 'show_on_front' ) && ! get_option( 'page_for_posts' ) ) : ?>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-edit-page">' . __( 'Edit your front page' ) . '</a>', get_edit_post_link( get_option( 'page_on_front' ) ) ); ?></li>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-add-page">' . __( 'Add additional pages' ) . '</a>', admin_url( 'post-new.php?post_type=page' ) ); ?></li>
				<?php elseif ( 'page' == get_option( 'show_on_front' ) ) : ?>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-edit-page">' . __( 'Edit your front page' ) . '</a>', get_edit_post_link( get_option( 'page_on_front' ) ) ); ?></li>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-add-page">' . __( 'Add additional pages' ) . '</a>', admin_url( 'post-new.php?post_type=page' ) ); ?></li>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-write-blog">' . __( 'Add a blog post' ) . '</a>', admin_url( 'post-new.php' ) ); ?></li>
				<?php else : ?>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-write-blog">' . __( 'Write your first blog post' ) . '</a>', admin_url( 'post-new.php' ) ); ?></li>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-add-page">' . __( 'Add an About page' ) . '</a>', admin_url( 'post-new.php?post_type=page' ) ); ?></li>
				<?php endif; ?>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-view-site">' . __( 'View your site' ) . '</a>', home_url( '/' ) ); ?></li>
				</ul>
			</div><!-- .welcome-panel-column -->
			<div class="welcome-panel-column welcome-panel-last">
				<h4><?php _e( 'More Actions' ); ?></h4>
				<ul>
					<li><?php printf( '<div class="welcome-icon welcome-widgets-menus">' . __( 'Manage <a href="%1$s">widgets</a> or <a href="%2$s">menus</a>' ) . '</div>', admin_url( 'widgets.php' ), admin_url( 'nav-menus.php' ) ); ?></li>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-comments">' . __( 'Turn comments on or off' ) . '</a>', admin_url( 'options-discussion.php' ) ); ?></li>
					<li><?php printf( '<a href="%s" class="welcome-icon welcome-learn-more">' . __( 'Learn more about getting started' ) . '</a>', __( 'http://codex.wordpress.org/First_Steps_With_WordPress' ) ); ?></li>
				</ul>
			</div><!-- .welcome-panel-column welcome-panel-last -->
		</div><!-- .welcome-panel-column-container -->
	<div><!-- .custom-welcome-panel-content -->
<div class="clear"></div>
<?php
}
add_action( 'welcome_panel', 'rc_my_welcome_panel' ); ?>