<?php get_header(); ?>

	<?php if (have_posts()) : ?>
	<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>

	<?php /* If this is a category archive */ if (is_category()) { ?>				
		<h8>Tudo sobre <b><?php echo single_cat_title(); ?></b></h8>
	<?php 
		$cat = get_category( get_query_var( 'cat' ) );
		$category = $cat->slug;
		echo do_shortcode('[ajax_load_more post_type="post, page" preloaded_amount="3" pause_override="false" scroll="false" posts_per_page="8" max_pages="0" button_label="mostrar mais" css_classes="infinite-scroll" transition="fade" transition_speed="1000" images_loaded="true" category="'.$category.'"]');
	?>

	<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h8>Arquivo de <b><?php the_time('j/m/y'); ?></b></h8>

	<?php } elseif (is_tag()){ ?>
		<h8>Posts sobre <b><?php single_tag_title(); ?></b></h8>

		<?php
			$tag = get_query_var('tag'); 
			echo do_shortcode('[ajax_load_more post_type="post, page" preloaded_amount="3" pause_override="false" scroll="false" posts_per_page="8" max_pages="0" button_label="mostrar mais" css_classes="infinite-scroll" transition="fade" transition_speed="1000" images_loaded="true" tag="'.$tag.'"]');
		?>
	<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h8> Arquivo de <b><?php the_time('m/Y'); ?></b></h8>

	<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h8> Arquivo de <b><?php the_time('Y'); ?></b></h8>
		
	<?php /* If this is a search */ } elseif (is_search()) { ?>
		<h8>Achou o que desejava?</h8><br /><br />
		
	<?php } elseif (is_author()){ ?>
		<h8>Posts escritos por <b><?php echo get_the_author() ; ?></b></h8>

	<?php 
		$author = get_the_author_meta('ID');
		echo do_shortcode('[ajax_load_more post_type="post" preloaded_amount="3" pause_override="false" scroll="false" posts_per_page="8" max_pages="0" button_label="mostrar mais" css_classes="infinite-scroll" transition="fade" transition_speed="1000" images_loaded="true" author="'.$author.'"]');
	?>

	<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h2>Arquivos do Blog</h2>

<?php } ?>
<?php while (have_posts()) : the_post(); ?>

<?php endwhile; ?>
<?php else : ?>

		<article>
			<h8>Não foi encontrado</h8>
			
			<?php add_filter( 'the_content', 'wpsites_list_cats' );
function wpsites_list_cats($content) {
if( is_singular('post') && is_main_query() ) {
$args = array(
'orderby' => 'name',
'exclude' => '',
'include' => '',
'parent' => 0
);
$categories = get_categories( $args );
echo'<nav id="primary-navigation" class="primary-navigation" role="navigation">';
foreach ( $categories as $category ) {
echo '<li><a href="' . get_category_link( $category->term_id ) . '">' .  $category->name . '</a></li>';
}
echo'</nav>';
return $content;
    }
}?>
		</article>
		
	
<?php endif; get_footer(); ?>